#include "customgui_datetime.h"
#include "c4d_string.h"
#include "c4d_gui.h"


static DateTimechooserLib *lib_DateTime = NULL;

static DateTimechooserLib *CheckLib(LONG offset)
{
	return (DateTimechooserLib*)CheckLib(DATETIME_GUI, offset, (C4DLibrary**)&lib_DateTime);
}

#define DateTimeCall(b) 			DateTimechooserLib *lib = CheckLib(LIBOFFSET(DateTimechooserLib,b)); \
															if (!lib || !lib->b) return; \
															(((iDateTimeData*)this)->*(lib->b))

#define DateTimeCallR(a,b) 		DateTimechooserLib *lib = CheckLib(LIBOFFSET(DateTimechooserLib,b)); \
															if (!lib || !lib->b) return a; \
															return (((iDateTimeData*)this)->*(lib->b))

#define DateTimeGuiCall(b) 		DateTimechooserLib *lib = CheckLib(LIBOFFSET(DateTimechooserLib,b)); \
															if (!lib || !lib->b) return; \
															(((iDateTimeControl*)this)->*(lib->b))

#define DateTimeGuiCallR(a,b) DateTimechooserLib *lib = CheckLib(LIBOFFSET(DateTimechooserLib,b)); \
															if (!lib || !lib->b) return a; \
															return (((iDateTimeControl*)this)->*(lib->b))

tagDateTime DateTimeControl::GetDateTime() { DateTimeGuiCallR(tagDateTime(), GetDateTimeGUI)(); }
void DateTimeControl::SetDateTime(tagDateTime *d, Bool bSetDate, Bool bSetTime) { DateTimeGuiCall(SetDateTimeGUI)(d, bSetDate, bSetTime); }

tagDateTime DateTimeData::GetDateTime() { DateTimeCallR(tagDateTime(), GetDateTimeData)(); }
void DateTimeData::SetDateTime(tagDateTime *d, Bool bSetDate, Bool bSetTime) { DateTimeCall(SetDateTimeData)(d, bSetDate, bSetTime); }

LReal GetJulianDay(tagDateTime &t)
{
	DateTimechooserLib *lib = CheckLib(LIBOFFSET(DateTimechooserLib, GetJulianDay)); if (!lib || !lib->GetJulianDay) return -1;
	return lib->GetJulianDay(t);
}

tagDateTime FromJulianDay(LReal j)
{
	DateTimechooserLib *lib = CheckLib(LIBOFFSET(DateTimechooserLib, GetJulianDay)); if (!lib || !lib->GetJulianDay) return tagDateTime();
	return lib->FromJulianDay(j);
}

void DateTimeNow(tagDateTime& t)
{
	DateTimechooserLib *lib = CheckLib(LIBOFFSET(DateTimechooserLib, DateTimeNow)); if (!lib || !lib->DateTimeNow) return;
	lib->DateTimeNow(t);
}


Bool tagDateTime::operator == (const tagDateTime& b) const
{
  return lYear == b.lYear && lMonth == b.lMonth && lDay == b.lDay && 
         lHour == b.lHour && lMinute == b.lMinute && lSecond == b.lSecond;
}

Bool tagDateTime::operator != (const tagDateTime& b) const { return !(*this == b); }
